<?php
/*--------------------------------------------------------------------
 OnGetProductWeightEventListener.php 2020-2-24
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 -------------------------------------------------------------------*/

declare(strict_types=1);

namespace Gambio\Shop\Product\Weight\Listener;

use Gambio\Shop\SellingUnit\Database\Unit\Events\Interfaces\OnGetProductWeightEventInterface;
use Gambio\Shop\SellingUnit\Database\Unit\Events\OnGetSellingUnitWeightEvent;
use Gambio\Shop\SellingUnit\Unit\ValueObjects\Weight;
use Throwable;

/**
 * Class OnGetProductWeightEventListener
 * @package Gambio\Shop\Product\Weight\Listener
 */
class OnGetProductWeightEventListener
{
    /**
     * @param OnGetProductWeightEventInterface $event
     *
     * @throws Throwable
     */
    public function __invoke(OnGetProductWeightEventInterface $event)
    {
        $weightFloat      = $event->product()->getWeight();
        $weight           = new Weight($weightFloat, $event->product()->showWeight());
        $sellingUnitEvent = new OnGetSellingUnitWeightEvent($event->productId(),
                                                            $event->modifiers(),
                                                            $event->product(),
                                                            $weight);
        
        $event->dispatcher()->dispatch($sellingUnitEvent);
        $event->setWeight($sellingUnitEvent->weight());
    }
}